"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sloBurnRateParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const durationSchema = _configSchema.schema.object({
  value: _configSchema.schema.number(),
  unit: _configSchema.schema.string()
});
const windowSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  burnRateThreshold: _configSchema.schema.number(),
  maxBurnRateThreshold: _configSchema.schema.nullable(_configSchema.schema.number()),
  longWindow: durationSchema,
  shortWindow: durationSchema,
  actionGroup: _configSchema.schema.string()
});
const dependency = _configSchema.schema.object({
  ruleId: _configSchema.schema.string(),
  actionGroupsToSuppressOn: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
const sloBurnRateParamsSchema = exports.sloBurnRateParamsSchema = _configSchema.schema.object({
  sloId: _configSchema.schema.string(),
  windows: _configSchema.schema.arrayOf(windowSchema),
  dependencies: _configSchema.schema.maybe(_configSchema.schema.arrayOf(dependency))
});