"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteJobs = void 0;
var _i18n = require("@kbn/i18n");
var _services = require("../../services");
var _selectors = require("../selectors");
var _action_types = require("../action_types");
var _refresh_jobs = require("./refresh_jobs");
var _detail_panel = require("./detail_panel");
var _kibana_services = require("../../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteJobs = jobIds => async (dispatch, getState) => {
  dispatch({
    type: _action_types.UPDATE_JOB_START
  });
  try {
    await (0, _services.createNoticeableDelay)((0, _services.deleteJobs)(jobIds));
  } catch (error) {
    dispatch({
      type: _action_types.UPDATE_JOB_FAILURE
    });
    return (0, _services.showApiError)(error, _i18n.i18n.translate('xpack.rollupJobs.deleteAction.errorTitle', {
      defaultMessage: 'Error deleting rollup jobs'
    }));
  }
  if (jobIds.length === 1) {
    (0, _kibana_services.getNotifications)().toasts.addSuccess(_i18n.i18n.translate('xpack.rollupJobs.deleteAction.successSingleNotificationTitle', {
      defaultMessage: `Rollup job ''{jobId}'' was deleted`,
      values: {
        jobId: jobIds[0]
      }
    }));
  } else {
    (0, _kibana_services.getNotifications)().toasts.addSuccess(_i18n.i18n.translate('xpack.rollupJobs.deleteAction.successMultipleNotificationTitle', {
      defaultMessage: '{count} rollup jobs were deleted',
      values: {
        count: jobIds.length
      }
    }));
  }

  // If we've just deleted a job we were looking at, we need to close the panel.
  const detailPanelJob = (0, _selectors.getDetailPanelJob)(getState());
  if (detailPanelJob && jobIds.includes(detailPanelJob.id)) {
    dispatch((0, _detail_panel.closeDetailPanel)());
  }
  dispatch({
    type: _action_types.UPDATE_JOB_SUCCESS
  });
  dispatch((0, _refresh_jobs.refreshJobs)());
};
exports.deleteJobs = deleteJobs;