"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unwrapKbnConfigSchema = exports.isNullableObjectType = exports.is = exports.getParamSchema = exports.convertQuery = exports.convertPathParameters = exports.convert = void 0;
var _joi = _interopRequireDefault(require("joi"));
var _configSchema = require("@kbn/config-schema");
var _lodash = require("lodash");
var _common = require("../common");
var _parse = require("./parse");
var _post_process_mutations = require("./post_process_mutations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isObjectType = schema => {
  return schema.type === 'object';
};
const isRecordType = schema => {
  return schema.type === 'record';
};

// See the `schema.nullable` type in @kbn/config-schema
const isNullableObjectType = schema => {
  if (schema.type === 'alternatives') {
    const {
      matches
    } = _joi.default.isSchema(schema) ? schema.describe() : schema;
    return matches.length === 2 && matches.every(match => {
      var _get;
      return match.schema.type === 'object' || match.schema.type === 'any' && (0, _lodash.get)(match, 'schema.flags.only') === true && ((_get = (0, _lodash.get)(match, 'schema.allow')) === null || _get === void 0 ? void 0 : _get.length) === 1 && (0, _lodash.get)(match, 'schema.allow.0') === null;
    });
  }
  return false;
};
exports.isNullableObjectType = isNullableObjectType;
const isEmptyObjectAllowsUnknowns = schema => {
  return isObjectType(schema) && Object.keys(schema.keys).length === 0 && (0, _lodash.get)(schema, 'flags.unknown') === true;
};
const createError = message => {
  return new Error(`[@kbn/config-schema converter] ${message}`);
};
function assertInstanceOfKbnConfigSchema(schema) {
  if (!is(schema)) {
    throw createError('Expected schema to be an instance of @kbn/config-schema');
  }
}
const unwrapKbnConfigSchema = schema => {
  assertInstanceOfKbnConfigSchema(schema);
  return schema.getSchema();
};
exports.unwrapKbnConfigSchema = unwrapKbnConfigSchema;
const convert = kbnConfigSchema => {
  const schema = unwrapKbnConfigSchema(kbnConfigSchema);
  const {
    result,
    shared
  } = (0, _parse.parse)({
    schema,
    ctx: (0, _post_process_mutations.createCtx)()
  });
  return {
    schema: result,
    shared
  };
};
exports.convert = convert;
const getParamSchema = (knownParameters, schemaKey) => {
  var _ref, _knownParameters$sche;
  return (_ref = (_knownParameters$sche = knownParameters[schemaKey]) !== null && _knownParameters$sche !== void 0 ? _knownParameters$sche :
  // Handle special path parameters
  knownParameters[schemaKey + '*']) !== null && _ref !== void 0 ? _ref : knownParameters[schemaKey + '?*'];
};
exports.getParamSchema = getParamSchema;
const convertObjectMembersToParameterObjects = (ctx, schema, knownParameters = {}, isPathParameter = false) => {
  let properties;
  const required = new Map();
  if (isNullableObjectType(schema)) {
    const {
      result
    } = (0, _parse.parse)({
      schema,
      ctx
    });
    if (result.anyOf) {
      var _result$anyOf$find;
      properties = (_result$anyOf$find = result.anyOf.find(s => !(0, _common.isReferenceObject)(s) && s.type === 'object')) === null || _result$anyOf$find === void 0 ? void 0 : _result$anyOf$find.properties;
    } else if (result.type === 'object') {
      properties = result.properties;
    }
  } else if (isObjectType(schema)) {
    var _result$required;
    const {
      result
    } = (0, _parse.parse)({
      schema,
      ctx
    });
    if ('$ref' in result) throw new Error(`Found a reference to "${result.$ref}". Runtime types with IDs are not supported in path or query parameters.`);
    properties = result.properties;
    ((_result$required = result.required) !== null && _result$required !== void 0 ? _result$required : []).forEach(key => required.set(key, true));
  } else if (isRecordType(schema)) {
    return [];
  } else {
    throw createError(`Expected record, object or nullable object type, but got '${schema.type}'`);
  }
  if (!properties) {
    throw createError(`Could not extract properties from ${schema.describe()}`);
  }
  return Object.entries(properties).map(([schemaKey, schemaObject]) => {
    const paramSchema = getParamSchema(knownParameters, schemaKey);
    if (!paramSchema && isPathParameter) {
      throw createError(`Unknown parameter: ${schemaKey}, are you sure this is in your path?`);
    }
    const isSubSchemaRequired = required.has(schemaKey);
    let description;
    let finalSchema;
    if (!(0, _common.isReferenceObject)(schemaObject)) {
      const {
        description: des,
        ...rest
      } = schemaObject;
      description = des;
      finalSchema = rest;
    } else {
      finalSchema = schemaObject;
    }
    return {
      name: schemaKey,
      in: isPathParameter ? 'path' : 'query',
      required: isPathParameter ? !paramSchema.optional : isSubSchemaRequired,
      schema: finalSchema,
      description
    };
  });
};
const convertQuery = kbnConfigSchema => {
  const schema = unwrapKbnConfigSchema(kbnConfigSchema);
  const ctx = (0, _post_process_mutations.createCtx)();
  const result = convertObjectMembersToParameterObjects(ctx, schema, {}, false);
  return {
    query: result,
    shared: ctx.getSharedSchemas()
  };
};
exports.convertQuery = convertQuery;
const convertPathParameters = (kbnConfigSchema, knownParameters) => {
  const schema = unwrapKbnConfigSchema(kbnConfigSchema);
  if (!isObjectType(schema) && !isNullableObjectType(schema)) {
    throw createError('Input parser for path params expected to be an object schema');
  }
  const ctx = (0, _post_process_mutations.createCtx)(); // For now context is not shared between body, params and queries
  const result = convertObjectMembersToParameterObjects(ctx, schema, knownParameters, true);
  return {
    params: result,
    shared: ctx.getSharedSchemas()
  };
};
exports.convertPathParameters = convertPathParameters;
const is = schema => {
  if ((0, _configSchema.isConfigSchema)(schema)) {
    const description = schema.getSchema().describe();
    // We ignore "any" @kbn/config-schema for the purposes of OAS generation...
    if (description.type === 'any' && !('allow' in description) || isEmptyObjectAllowsUnknowns(description)) {
      return false;
    }
    return true;
  }
  return false;
};
exports.is = is;