"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeUniqueFieldsByName = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mergeUniqueFieldsByName = (firstFields, secondFields) => {
  const uniqueMap = new Map();
  const addToMap = fields => fields.forEach(field => {
    uniqueMap.set(field.name, field);
  });
  addToMap(firstFields);
  addToMap(secondFields);
  return Array.from(uniqueMap.values());
};
exports.mergeUniqueFieldsByName = mergeUniqueFieldsByName;