"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _inferenceCommon = require("@kbn/inference-common");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class IndexManager {
  constructor({
    elserInferenceId,
    logger,
    isServerlessPlatform
  }) {
    (0, _defineProperty2.default)(this, "elserInferenceId", void 0);
    (0, _defineProperty2.default)(this, "log", void 0);
    (0, _defineProperty2.default)(this, "isServerlessPlatform", void 0);
    this.elserInferenceId = elserInferenceId;
    this.log = logger;
    this.isServerlessPlatform = isServerlessPlatform;
  }
  async createAndPopulateIndex({
    indexName,
    mappings,
    manifest,
    archive,
    esClient
  }) {
    if (this.elserInferenceId === _inferenceCommon.defaultInferenceEndpoints.ELSER) {
      await (0, _utils.ensureDefaultElserDeployed)({
        client: esClient
      });
    }
    const params = {
      indexName,
      legacySemanticText: (0, _utils.isLegacySemanticTextVersion)(manifest.formatVersion),
      esClient,
      elserInferenceId: this.elserInferenceId,
      log: this.log
    };
    await (0, _utils.createIndex)({
      ...params,
      mappings,
      isServerless: this.isServerlessPlatform
    });
    await (0, _utils.populateIndex)({
      ...params,
      archive
    });
  }
  async deleteIndex({
    indexName,
    esClient
  }) {
    try {
      await esClient.indices.delete({
        index: indexName
      }, {
        ignore: [404]
      });
      this.log.debug(`Deleted index [${indexName}]`);
    } catch (error) {
      this.log.warn(`Failed to delete index [${indexName}]: ${error.message}`);
    }
  }
  async hasIndex({
    indexName,
    esClient
  }) {
    try {
      return await esClient.indices.exists({
        index: indexName
      });
    } catch (error) {
      this.log.warn(`Failed to check if index exists [${indexName}]: ${error.message}`);
      return false;
    }
  }
}
exports.IndexManager = IndexManager;