"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseQuery = parseQuery;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function parseQuery(query, types) {
  let queryText;
  let visibleTypes;
  let selectedTags;
  if (query) {
    if (query.ast.getTermClauses().length) {
      queryText = query.ast.getTermClauses().map(clause => clause.value).join(' ');
    }
    if (query.ast.getFieldClauses('type')) {
      const displayedTypes = query.ast.getFieldClauses('type')[0].value;
      const displayNameToNameMap = types.reduce((map, type) => {
        map.set(type.displayName, type.name);
        return map;
      }, new Map());
      visibleTypes = displayedTypes.map(type => {
        var _displayNameToNameMap;
        return (_displayNameToNameMap = displayNameToNameMap.get(type)) !== null && _displayNameToNameMap !== void 0 ? _displayNameToNameMap : type;
      });
    }
    if (query.ast.getFieldClauses('tag')) {
      selectedTags = query.ast.getFieldClauses('tag')[0].value;
    }
  }
  return {
    queryText,
    visibleTypes,
    selectedTags
  };
}