"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsManagementActionService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class SavedObjectsManagementActionService {
  constructor() {
    (0, _defineProperty2.default)(this, "actions", new Map());
  }
  setup() {
    return {
      register: action => this.register(action)
    };
  }
  start(spacesApi) {
    if (spacesApi && !spacesApi.hasOnlyDefaultSpace) {
      this.register(new _actions.ShareToSpaceSavedObjectsManagementAction(spacesApi.ui));
      this.register(new _actions.CopyToSpaceSavedObjectsManagementAction(spacesApi.ui));
    }
    return {
      has: actionId => this.actions.has(actionId),
      getAll: () => [...this.actions.values()]
    };
  }
  register(action) {
    if (this.actions.has(action.id)) {
      throw new Error(`Saved Objects Management Action with id '${action.id}' already exists`);
    }
    this.actions.set(action.id, action);
  }
}
exports.SavedObjectsManagementActionService = SavedObjectsManagementActionService;