"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initQueryClient = initQueryClient;
var _reactQuery = require("@kbn/react-query");
var _get_error_message = require("../utils/get_error_message");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initQueryClient(toasts) {
  return new _reactQuery.QueryClient({
    queryCache: new _reactQuery.QueryCache({
      onError: error => {
        // 404s are often functionally okay and shouldn't show toasts by default
        if ((0, _get_error_message.getErrorCode)(error) === 404) {
          return;
        }
        if ((0, _get_error_message.isKibanaServerError)(error) && !error.skipToast) {
          toasts.addError(error, {
            title: error.name,
            toastMessage: (0, _get_error_message.getErrorMessage)(error),
            toastLifeTimeMs: 1000
          });
        }
      }
    })
  });
}