"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _result_metadata = require("./result/result_metadata");
var _ = require("..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/packages/shared/kbn-search-index-documents/components/document_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DocumentList = ({
  executionTime,
  dataTelemetryIdPrefix,
  docs,
  docsPerPage,
  isLoading,
  mappings,
  meta,
  onPaginate,
  setDocsPerPage,
  onDocumentClick,
  resultProps = {}
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const getIconType = size => {
    return size === docsPerPage ? 'check' : 'empty';
  };
  const pageCount = meta !== null && meta !== void 0 && meta.pageSize ? Math.ceil(meta.totalItemCount / (meta === null || meta === void 0 ? void 0 : meta.pageSize)) : 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndexDocuments.documentList.description",
    defaultMessage: "Showing {results} of {total}. Search results maxed at {maximum} documents.",
    values: {
      maximum: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: 10000,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 28
        }
      }),
      results: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: docs.length,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 23
        }
      })),
      total: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: meta.totalItemCount,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 23
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 15
    }
  })))), executionTime !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "executionTimeBadge",
    color: "default",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }, executionTime, " ms"))), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }), docs.map(doc => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: doc._id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_.Result, (0, _extends2.default)({
      fields: (0, _result_metadata.resultToFieldFromMappingResponse)(doc, mappings),
      metaData: (0, _result_metadata.resultMetaData)(doc),
      onDocumentClick: onDocumentClick ? () => onDocumentClick(doc) : undefined
    }, resultProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 13
      }
    })));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": _i18n.i18n.translate('xpack.searchIndexDocuments.documentList.paginationAriaLabel', {
      defaultMessage: 'Document lists pagination'
    }),
    pageCount: pageCount,
    activePage: meta.pageIndex,
    onPageClick: onPaginate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  })), setDocsPerPage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "aria-label": _i18n.i18n.translate('xpack.searchIndexDocuments.documentList.docsPerPage', {
      defaultMessage: 'Document count per page dropdown'
    }),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-telemetry-id": `${dataTelemetryIdPrefix}-documents-docsPerPage`,
      size: "s",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: () => {
        setIsPopoverOpen(true);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.searchIndexDocuments.documentList.pagination.itemsPerPage', {
      defaultMessage: 'Documents per page: {docPerPage}',
      values: {
        docPerPage: docsPerPage
      }
    })),
    isOpen: isPopoverOpen,
    closePopover: () => {
      setIsPopoverOpen(false);
    },
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "10 rows",
      icon: getIconType(10),
      onClick: () => {
        setIsPopoverOpen(false);
        setDocsPerPage(10);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.searchIndexDocuments.documentList.paginationOptions.option', {
      defaultMessage: '{docCount} documents',
      values: {
        docCount: 10
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "25 rows",
      icon: getIconType(25),
      onClick: () => {
        setIsPopoverOpen(false);
        setDocsPerPage(25);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.searchIndexDocuments.documentList.paginationOptions.option', {
      defaultMessage: '{docCount} documents',
      values: {
        docCount: 25
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "50 rows",
      icon: getIconType(50),
      onClick: () => {
        setIsPopoverOpen(false);
        setDocsPerPage(50);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.searchIndexDocuments.documentList.paginationOptions.option', {
      defaultMessage: '{docCount} documents',
      values: {
        docCount: 50
      }
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 7
    }
  }), meta.totalItemCount > 9999 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchIndexDocuments.documentList.resultLimitTitle",
      defaultMessage: "Results are limited to {number} documents",
      values: {
        number: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
          value: 10000,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 235,
            columnNumber: 25
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 13
      }
    }),
    iconType: "search",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndexDocuments.documentList.resultLimit",
    defaultMessage: "Only the first {number} results are available for paging. Please use the search bar to filter down your results.",
    values: {
      number: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: 10000,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 246,
          columnNumber: 25
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 13
    }
  }))));
};
exports.DocumentList = DocumentList;