"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateRandomIndexName = generateRandomIndexName;
exports.getFirstNewIndexName = getFirstNewIndexName;
exports.indexHealthToHealthColor = exports.healthColorsMap = void 0;
exports.isValidIndexName = isValidIndexName;
exports.normalizeHealth = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// see https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-create-index.html for the current rules

function isValidIndexName(name) {
  const byteLength = encodeURI(name).split(/%(?:u[0-9A-F]{2})?[0-9A-F]{2}|./).length - 1;
  const reg = new RegExp('[\\\\/:*?"<>|\\s,#]+');
  const indexPatternInvalid = byteLength > 255 ||
  // name can't be greater than 255 bytes
  name !== name.toLowerCase() ||
  // name should be lowercase
  name.match(/^[-_+.]/) !== null ||
  // name can't start with these chars
  name.match(reg) !== null; // name can't contain these chars

  return !indexPatternInvalid;
}
function generateRandomIndexName(prefix = 'search-', randomSuffixLength = 4) {
  const suffixCharacters = 'abcdefghijklmnopqrstuvwxyz0123456789';
  const charsLength = suffixCharacters.length;
  let result = prefix;
  let counter = 0;
  do {
    result += suffixCharacters.charAt(Math.random() * charsLength);
    counter++;
  } while (counter < randomSuffixLength);
  return result;
}
function getFirstNewIndexName(startingIndexNames, currentIndexNames) {
  for (const index of currentIndexNames) {
    if (startingIndexNames.indexOf(index) === -1) {
      return index;
    }
  }
  return undefined;
}
const healthColorsMap = exports.healthColorsMap = {
  red: 'danger',
  green: 'success',
  yellow: 'warning',
  unavailable: ''
};
const normalizeHealth = health => health.toLowerCase();
exports.normalizeHealth = normalizeHealth;
const indexHealthToHealthColor = (health = 'unavailable') => {
  var _healthColorsMap$norm;
  return (_healthColorsMap$norm = healthColorsMap[normalizeHealth(health)]) !== null && _healthColorsMap$norm !== void 0 ? _healthColorsMap$norm : healthColorsMap.unavailable;
};
exports.indexHealthToHealthColor = indexHealthToHealthColor;