"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlaygroundLicensingCTA = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_license_status = require("../hooks/use_license_status");
var _use_kibana = require("../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_playground/public/components/licensing_cta.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PlaygroundLicensingCTA = () => {
  const {
    application,
    licenseManagement
  } = (0, _use_kibana.useKibana)().services;
  const {
    hasExpiredLicense
  } = (0, _use_license_status.usePlaygroundLicenseStatus)();
  if (licenseManagement === undefined || licenseManagement.enabled === false) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.searchPlayground.unavailable.upgradeTitle', {
      defaultMessage: 'Upgrade your license to use the Playground.'
    })));
  }
  if (hasExpiredLicense) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.searchPlayground.unavailable.startTrial.expiredTooltip', {
        defaultMessage: 'Your license has expired. Manage your license to continue using Enterprise features.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "playgroundsStartTrialButton",
      fill: true,
      disabled: true,
      fullWidth: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.searchPlayground.unavailable.startTrial.button', {
      defaultMessage: 'Start trial'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "playgroundsManageLicenseButton",
      "aria-label": _i18n.i18n.translate('xpack.searchPlayground.unavailable.manageLicense.aria-label', {
        defaultMessage: 'Open license management to update your license.'
      }),
      onClick: () => application.navigateToApp('management', {
        path: 'stack/license_management/home'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.searchPlayground.unavailable.manageLicense.button', {
      defaultMessage: 'Manage license'
    }))));
  }
  return /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "aria-label": _i18n.i18n.translate('xpack.searchPlayground.unavailable.manageLicense.aria-label', {
      defaultMessage: 'Open license management to start a free trial.'
    }),
    "data-test-subj": "playgroundsStartTrialButton",
    fill: true,
    fullWidth: false,
    onClick: () => application.navigateToApp('management', {
      path: 'stack/license_management/home'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.searchPlayground.unavailable.startTrial.button', {
    defaultMessage: 'Start trial'
  })));
};
exports.PlaygroundLicensingCTA = PlaygroundLicensingCTA;