"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndicesValidation = void 0;
var _react = require("react");
var _use_query_indices = require("./use_query_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIndicesValidation = unvalidatedIndices => {
  const [isValidated, setIsValidated] = (0, _react.useState)(false);
  const [validIndices, setValidIndices] = (0, _react.useState)([]);
  const {
    indices,
    isFetched: isIndicesLoaded
  } = (0, _use_query_indices.useQueryIndices)({
    query: unvalidatedIndices.join(','),
    exact: true
  });
  (0, _react.useEffect)(() => {
    if (isIndicesLoaded) {
      setValidIndices(indices.filter(index => unvalidatedIndices.includes(index)));
      setIsValidated(true);
    }
  }, [unvalidatedIndices, indices, isIndicesLoaded]);
  return {
    isValidated,
    validIndices
  };
};
exports.useIndicesValidation = useIndicesValidation;