"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStore = exports.initialState = void 0;
var _react = require("react");
var _reducer = require("./reducer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = exports.initialState = {
  profiling: false,
  pristine: true,
  highlightDetails: null,
  activeTab: null,
  currentResponse: null
};
const useStore = () => {
  const [state, dispatch] = (0, _react.useReducer)(_reducer.reducer, initialState);
  return {
    state,
    dispatch
  };
};
exports.useStore = useStore;