"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toSimpleRuleSchedule = toSimpleRuleSchedule;
var _date_math = require("@kbn/securitysolution-utils/date_math");
var _time_duration = require("@kbn/securitysolution-utils/time_duration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Transforms RuleSchedule to SimpleRuleSchedule by replacing `from` and `to` with `lookback`.
 *
 * The transformation is only possible when `to` equals to `now` and result `lookback` is non-negative.
 */
function toSimpleRuleSchedule(ruleSchedule) {
  if (ruleSchedule.to !== 'now') {
    return undefined;
  }
  const lookBackMs = (0, _date_math.calcDateMathDiff)(ruleSchedule.from, `now-${ruleSchedule.interval}`);
  if (lookBackMs === undefined || lookBackMs < 0) {
    return undefined;
  }
  return {
    interval: ruleSchedule.interval,
    lookback: _time_duration.TimeDuration.fromMilliseconds(lookBackMs).toString()
  };
}