"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InitEntityStoreResponse = exports.InitEntityStoreRequestBody = void 0;
var _zod = require("@kbn/zod");
var _common = require("./common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Enable Entity Store
 *   version: 2023-10-31
 */

const InitEntityStoreRequestBody = exports.InitEntityStoreRequestBody = _zod.z.object({
  /**
   * The number of historical values to keep for each field.
   */
  fieldHistoryLength: _zod.z.number().int().optional().default(10),
  indexPattern: _common.IndexPattern.optional(),
  filter: _zod.z.string().optional(),
  entityTypes: _zod.z.array(_common.EntityType).optional(),
  enrichPolicyExecutionInterval: _common.Interval.optional(),
  /**
   * The field to use as the timestamp.
   */
  timestampField: _zod.z.string().optional().default('@timestamp'),
  /**
   * The amount of time the transform looks back to calculate the aggregations.
   */
  lookbackPeriod: _zod.z.string().regex(/[smdh]$/).optional().default('3h'),
  /**
   * The timeout for initializing the aggregating transform.
   */
  timeout: _zod.z.string().regex(/[smdh]$/).optional().default('180s'),
  /**
   * The frequency at which the transform will run.
   */
  frequency: _zod.z.string().regex(/[smdh]$/).optional().default('1m'),
  /**
   * The delay before the transform will run.
   */
  delay: _zod.z.string().regex(/[smdh]$/).optional().default('1m'),
  /**
   * The number of documents per second to process.
   */
  docsPerSecond: _zod.z.number().int().optional().default(-1),
  /**
   * The initial page size to use for the composite aggregation of each checkpoint.
   */
  maxPageSearchSize: _zod.z.number().int().optional().default(500)
});
const InitEntityStoreResponse = exports.InitEntityStoreResponse = _zod.z.object({
  succeeded: _zod.z.boolean().optional(),
  engines: _zod.z.array(_common.EngineDescriptor).optional()
});