"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchFleetLatestAvailableAgentVersion = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _format_axios_error = require("../format_axios_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Fetches the latest version of the Elastic Agent available for download
 * @param kbnClient
 */

const fetchFleetLatestAvailableAgentVersion = async kbnClient => {
  return kbnClient.request({
    method: 'GET',
    path: _common.AGENT_API_ROUTES.AVAILABLE_VERSIONS_PATTERN,
    headers: {
      'elastic-api-version': '2023-10-31'
    }
  }).then(response => response.data.items[0]).catch(_format_axios_error.catchAxiosErrorFormatAndThrow);
};
exports.fetchFleetLatestAvailableAgentVersion = fetchFleetLatestAvailableAgentVersion;