"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.get = get;
var _fp = _interopRequireDefault(require("lodash/fp"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Proxy for lodash fp `get` with better type inference.
 * Overloaded to support both imperative and point free style
 *
 * Dynamic paths are supported if an array is passed as `path`.
 * If an array is passed as `path`, it needs to be `const`: `["foo", "bar"] as const`
 **/

function get(...args) {
  if (args.length === 2) {
    const [obj, path] = args;
    return _fp.default.get(path)(obj);
  }
  const [path] = args;
  return _fp.default.get(path);
}