"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopValuesPopoverService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TopValuesPopoverService {
  constructor() {
    (0, _defineProperty2.default)(this, "currentPopoverSubject$", void 0);
    this.currentPopoverSubject$ = new _rxjs.BehaviorSubject(undefined);
  }
  showPopover(data) {
    return this.currentPopoverSubject$.next(data);
  }
  closePopover() {
    return this.currentPopoverSubject$.next(undefined);
  }
  getObservable() {
    return this.currentPopoverSubject$.asObservable();
  }
}
exports.TopValuesPopoverService = TopValuesPopoverService;