"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformAssetAggregationToChartData = transformAssetAggregationToChartData;
var _i18n = require("@kbn/i18n");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tooltipOtherLabel = _i18n.i18n.translate('xpack.securitySolution.assetInventory.chart.tooltip.otherLabel', {
  defaultMessage: 'Other'
});
const UNCATEGORIZED_LABEL = _i18n.i18n.translate('xpack.securitySolution.assetInventory.chart.uncategorizedLabel', {
  defaultMessage: 'uncategorized'
});
function transformAssetAggregationToChartData(agg) {
  const result = [];
  for (const typeBucket of agg.entityType.buckets) {
    for (const subtypeBucket of typeBucket.entitySubType.buckets) {
      // Format "Uncategorized" labels to include the entity type
      const formattedSubType = subtypeBucket.key === 'Uncategorized' ? `${typeBucket.key} (${UNCATEGORIZED_LABEL})` : subtypeBucket.key;
      result.push({
        [_constants.ASSET_FIELDS.ENTITY_TYPE]: typeBucket.key,
        [_constants.ASSET_FIELDS.ENTITY_SUB_TYPE]: formattedSubType,
        count: subtypeBucket.doc_count
      });
    }
    if (typeBucket.entitySubType.sum_other_doc_count > 0) {
      result.push({
        [_constants.ASSET_FIELDS.ENTITY_TYPE]: typeBucket.key,
        [_constants.ASSET_FIELDS.ENTITY_SUB_TYPE]: `${typeBucket.key} - ${tooltipOtherLabel}`,
        count: typeBucket.entitySubType.sum_other_doc_count
      });
    }
  }
  return result;
}