"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchChartData = useFetchChartData;
var _reactQuery = require("@kbn/react-query");
var _rxjs = require("rxjs");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _react = require("react");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../constants");
var _get_top_assets_query = require("./get_top_assets_query");
var _transform_asset_aggregation_to_chart_data = require("./transform_asset_aggregation_to_chart_data");
var _data_view_context = require("../data_view_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchChartData(options) {
  const {
    data,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const {
    dataView
  } = (0, _data_view_context.useDataViewContext)();
  const dataViewIndexPattern = (0, _react.useMemo)(() => {
    return dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern();
  }, [dataView]);
  return (0, _reactQuery.useQuery)([_constants.QUERY_KEY_ASSET_INVENTORY, _constants.QUERY_KEY_CHART_DATA, {
    params: options
  }], async () => {
    const {
      rawResponse: {
        aggregations
      }
    } = await (0, _rxjs.lastValueFrom)(data.search.search({
      params: (0, _get_top_assets_query.getTopAssetsQuery)(options, dataViewIndexPattern)
    }));
    if (!aggregations) {
      throw new Error('expected aggregations to be defined');
    }
    return (0, _transform_asset_aggregation_to_chart_data.transformAssetAggregationToChartData)(aggregations);
  }, {
    enabled: options.enabled && !!dataViewIndexPattern,
    keepPreviousData: true,
    onError: err => (0, _cloudSecurityPosture.showErrorToast)(toasts, err)
  });
}