"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Settings = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _constants = require("../../settings_flyout/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/header/settings/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const settingsButtonStyles = (0, _react.css)`
  border-bottom-left-radius: 0;
  border-top-left-radius: 0;
  min-width: 40px;
  padding-inline: 0;
  width: 40px;
`;
const SettingsComponent = ({
  isLoading,
  openFlyout
}) => {
  const onClick = (0, _react2.useCallback)(() => openFlyout(_constants.SETTINGS_TAB_ID),
  // open the settings tab in the flyout
  [openFlyout]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "settingsTooltip",
    content: i18n.SETTINGS_TOOLTIP,
    position: "bottom",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "aria-label": i18n.SETTINGS,
    color: "primary",
    css: settingsButtonStyles,
    "data-test-subj": "settings",
    iconType: "indexSettings",
    isDisabled: isLoading,
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }));
};
SettingsComponent.displayName = 'Settings';
const Settings = exports.Settings = /*#__PURE__*/_react2.default.memo(SettingsComponent);