"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deserializeFilters = void 0;
var _esQuery = require("@kbn/es-query");
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const filtersSchema = _zod.z.array(_zod.z.object({
  $state: _zod.z.union([_zod.z.object({
    store: _zod.z.nativeEnum(_esQuery.FilterStateStore)
  }), _zod.z.undefined()]).optional(),
  meta: _zod.z.object({}).catchall(_zod.z.unknown()),
  query: _zod.z.union([_zod.z.record(_zod.z.string(), _zod.z.any()), _zod.z.undefined()]).optional()
}));
const deserializeFilters = value => {
  try {
    return filtersSchema.parse(JSON.parse(value));
  } catch {
    return [];
  }
};
exports.deserializeFilters = deserializeFilters;