"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowBadge = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _is_attack_discovery_alert = require("../../../../../../utils/is_attack_discovery_alert");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/attack_discovery_panel/panel_header/primary_interactions/badges/workflow_badge/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NON_I18N_WORKFLOW_STATUS_FIELD_NAME = 'kibana.alert.workflow_status'; // intentionally not i18n

const WorkflowBadgeComponent = ({
  attackDiscovery
}) => {
  if ((0, _is_attack_discovery_alert.isAttackDiscoveryAlert)(attackDiscovery) && attackDiscovery.alertWorkflowStatus != null) {
    const {
      alertWorkflowStatus
    } = attackDiscovery;
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
      content: NON_I18N_WORKFLOW_STATUS_FIELD_NAME,
      "data-test-subj": "workflowBadgeTooltip",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
      "aria-label": NON_I18N_WORKFLOW_STATUS_FIELD_NAME,
      color: "hollow",
      "data-test-subj": "workflowBadge",
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement("span", {
      css: (0, _react.css)`
              text-transform: capitalize;
            `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 11
      }
    }, alertWorkflowStatus)));
  }
  return null;
};
WorkflowBadgeComponent.displayName = 'WorkflowBadge';
const WorkflowBadge = exports.WorkflowBadge = /*#__PURE__*/_react2.default.memo(WorkflowBadgeComponent);