"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateAlertsModal = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/take_action/update_alerts_modal/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UpdateAlertsModalComponent = ({
  alertsCount,
  attackDiscoveriesCount,
  onCancel,
  onClose,
  onConfirm,
  workflowStatus
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const modalId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'confirmModal'
  });
  const titleId = (0, _eui.useGeneratedHtmlId)();
  const markDiscoveriesOnly = (0, _react2.useCallback)(() => {
    onConfirm({
      updateAlerts: false,
      workflowStatus
    });
  }, [onConfirm, workflowStatus]);
  const markAlertsAndDiscoveries = (0, _react2.useCallback)(() => {
    onConfirm({
      updateAlerts: true,
      workflowStatus
    });
  }, [onConfirm, workflowStatus]);
  const confirmButtons = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
            margin-right: ${euiTheme.size.m};
          `,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "markDiscoveriesOnly",
    onClick: markDiscoveriesOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, i18n.MARK_DISCOVERIES_ONLY({
    attackDiscoveriesCount,
    workflowStatus
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "markAlertsAndDiscoveries",
    color: "primary",
    fill: true,
    onClick: markAlertsAndDiscoveries,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, i18n.MARK_ALERTS_AND_DISCOVERIES({
    alertsCount,
    attackDiscoveriesCount,
    workflowStatus
  })))), [alertsCount, attackDiscoveriesCount, euiTheme.size.m, markAlertsAndDiscoveries, markDiscoveriesOnly, workflowStatus]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiModal, {
    "aria-labelledby": titleId,
    "data-test-subj": "confirmModal",
    id: modalId,
    onClose: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeaderTitle, {
    title: titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, i18n.UPDATE_ALERTS)), /*#__PURE__*/_react2.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    "data-test-subj": "modalBody",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }, i18n.UPDATE_ALERTS_ASSOCIATED({
    alertsCount,
    attackDiscoveriesCount
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    responsive: false,
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
              margin-right: ${euiTheme.size.xxxl};
            `,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "cancel",
    flush: "left",
    onClick: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 13
    }
  }, i18n.CANCEL)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  }, confirmButtons))));
};
UpdateAlertsModalComponent.displayName = 'UpdateAlertsModal';
const UpdateAlertsModal = exports.UpdateAlertsModal = /*#__PURE__*/_react2.default.memo(UpdateAlertsModalComponent);