"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MARKED_ATTACK_DISCOVERIES = exports.ERROR_UPDATING_ATTACK_DISCOVERIES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MARKED_ATTACK_DISCOVERIES = ({
  attackDiscoveries,
  kibanaAlertWorkflowStatus
}) => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.useAttackDiscoveryBulk.markedAttackDiscoveriesToast', {
  defaultMessage: 'Marked {attackDiscoveries, plural, one {attack discovery} other {# attack discoveries}} as {kibanaAlertWorkflowStatus}',
  values: {
    attackDiscoveries,
    kibanaAlertWorkflowStatus
  }
});
exports.MARKED_ATTACK_DISCOVERIES = MARKED_ATTACK_DISCOVERIES;
const ERROR_UPDATING_ATTACK_DISCOVERIES = exports.ERROR_UPDATING_ATTACK_DISCOVERIES = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.useAttackDiscoveryBulk.errorUpdatingAttackDiscoveriesErrorToast', {
  defaultMessage: 'Error updating Attack discoveries'
});