"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKibanaFeatureFlags = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _react = require("react");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useKibanaFeatureFlags = () => {
  const {
    services: {
      featureFlags
    }
  } = (0, _kibana.useKibana)();
  const attackDiscoveryPublicApiEnabled = (0, _react.useMemo)(() => featureFlags.getBooleanValue(_elasticAssistantCommon.ATTACK_DISCOVERY_PUBLIC_API_ENABLED_FEATURE_FLAG, true), [featureFlags]);
  return {
    attackDiscoveryPublicApiEnabled
  };
};
exports.useKibanaFeatureFlags = useKibanaFeatureFlags;