"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIMELINE_URL_IS_NOT_VALID = exports.TIMELINE_ID = exports.TIMELINE_ERROR_TITLE = exports.NO_TIMELINE_NAME_FOUND = exports.NO_TIMELINE_ID_FOUND = exports.NO_PARENTHESES = exports.INSERT_TIMELINE = exports.FAILED_TO_RETRIEVE_TIMELINE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INSERT_TIMELINE = exports.INSERT_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.markdownEditor.plugins.timeline.insertTimelineButtonLabel', {
  defaultMessage: 'Insert timeline link'
});
const TIMELINE_ID = timelineId => _i18n.i18n.translate('xpack.securitySolution.markdownEditor.plugins.timeline.toolTip.timelineId', {
  defaultMessage: 'Timeline id: { timelineId }',
  values: {
    timelineId
  }
});
exports.TIMELINE_ID = TIMELINE_ID;
const NO_TIMELINE_NAME_FOUND = exports.NO_TIMELINE_NAME_FOUND = _i18n.i18n.translate('xpack.securitySolution.markdownEditor.plugins.timeline.noTimelineNameFoundErrorMsg', {
  defaultMessage: 'No timeline name found'
});
const NO_TIMELINE_ID_FOUND = exports.NO_TIMELINE_ID_FOUND = _i18n.i18n.translate('xpack.securitySolution.markdownEditor.plugins.timeline.noTimelineIdFoundErrorMsg', {
  defaultMessage: 'No timeline id found'
});
const TIMELINE_URL_IS_NOT_VALID = timelineUrl => _i18n.i18n.translate('xpack.securitySolution.markdownEditor.plugins.timeline.toolTip.timelineUrlIsNotValidErrorMsg', {
  defaultMessage: 'Timeline URL is not valid => {timelineUrl}',
  values: {
    timelineUrl
  }
});
exports.TIMELINE_URL_IS_NOT_VALID = TIMELINE_URL_IS_NOT_VALID;
const NO_PARENTHESES = exports.NO_PARENTHESES = _i18n.i18n.translate('xpack.securitySolution.markdownEditor.plugins.timeline.noParenthesesErrorMsg', {
  defaultMessage: 'Expected left parentheses'
});
const FAILED_TO_RETRIEVE_TIMELINE = timelineId => _i18n.i18n.translate('xpack.securitySolution.markdownEditor.plugins.timeline.failedRetrieveTimelineErrorMsg', {
  defaultMessage: 'Failed to retrieve timeline id: { timelineId }',
  values: {
    timelineId
  }
});
exports.FAILED_TO_RETRIEVE_TIMELINE = FAILED_TO_RETRIEVE_TIMELINE;
const TIMELINE_ERROR_TITLE = exports.TIMELINE_ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.markdownEditor.plugins.timeline.timelineErrorTitle', {
  defaultMessage: 'Timeline Error'
});