"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BarText = exports.BarSpacer = exports.BarSection = exports.BarGroup = exports.BarAction = exports.Bar = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * UTILITY BAR
 */

const Bar = exports.Bar = _styledComponents.default.aside.attrs({
  className: 'siemUtilityBar'
})`
  ${({
  border,
  theme
}) => (0, _styledComponents.css)`
    ${border && (0, _styledComponents.css)`
      border-bottom: ${theme.eui.euiBorderThin};
      padding-bottom: ${theme.eui.euiSizeXS};
      align-items: center;
    `}

    @media only screen and (min-width: ${theme.eui.euiBreakpoints.l}) {
      display: flex;
      justify-content: space-between;
    }
  `}
`;
Bar.displayName = 'Bar';
const BarSection = exports.BarSection = _styledComponents.default.div.attrs({
  className: 'siemUtilityBar__section'
})`
  ${({
  grow,
  theme
}) => (0, _styledComponents.css)`
    & + & {
      margin-top: ${theme.eui.euiSizeS};
      align-items: center;
    }

    @media only screen and (min-width: ${theme.eui.euiBreakpoints.m}) {
      display: flex;
      flex-wrap: wrap;
    }

    @media only screen and (min-width: ${theme.eui.euiBreakpoints.l}) {
      & + & {
        margin-top: 0;
        margin-left: ${theme.eui.euiSize};
      }
    }
    ${grow && (0, _styledComponents.css)`
      flex: 1;
    `}
  `}
`;
BarSection.displayName = 'BarSection';
const BarGroup = exports.BarGroup = _styledComponents.default.div.attrs({
  className: 'siemUtilityBar__group'
})`
  ${({
  grow,
  theme
}) => (0, _styledComponents.css)`
    align-items: flex-start;
    display: flex;
    flex-wrap: wrap;

    & + & {
      margin-top: ${theme.eui.euiSizeS};
    }

    @media only screen and (min-width: ${theme.eui.euiBreakpoints.m}) {
      border-right: ${theme.eui.euiBorderThin};
      flex-wrap: nowrap;
      margin-right: ${theme.eui.euiSizeM};
      padding-right: ${theme.eui.euiSizeM};

      & + & {
        margin-top: 0;
      }

      &:last-child {
        border-right: none;
        margin-right: 0;
        padding-right: 0;
      }
    }

    & > * {
      margin-right: ${theme.eui.euiSize};

      &:last-child {
        margin-right: 0;
      }
    }
    ${grow && (0, _styledComponents.css)`
      flex: 1;
    `}
  `}
`;
BarGroup.displayName = 'BarGroup';
const BarText = exports.BarText = _styledComponents.default.p.attrs(({
  className
}) => ({
  className: className || 'siemUtilityBar__text'
}))`
  ${({
  shouldWrap,
  theme
}) => (0, _styledComponents.css)`
    color: ${theme.eui.euiTextSubduedColor};
    font-size: ${theme.eui.euiFontSizeXS};
    line-height: ${theme.eui.euiLineHeight};
    white-space: ${shouldWrap ? 'normal' : 'nowrap'};
  `}
`;
BarText.displayName = 'BarText';
const BarAction = exports.BarAction = _styledComponents.default.div.attrs({
  className: 'siemUtilityBar__action'
})`
  ${({
  theme
}) => (0, _styledComponents.css)`
    font-size: ${theme.eui.euiFontSizeXS};
  `}
`;
BarAction.displayName = 'BarAction';
const BarSpacer = exports.BarSpacer = _styledComponents.default.div.attrs({
  className: 'siemUtilityBar__spacer'
})`
  ${() => (0, _styledComponents.css)`
    flex: 1;
  `}
`;
BarSpacer.displayName = 'BarSpacer';