"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setAlertAssignees = void 0;
var _constants = require("../../../../common/constants");
var _kibana = require("../../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setAlertAssignees = async ({
  assignees,
  ids,
  signal
}) => {
  return _kibana.KibanaServices.get().http.fetch(_constants.DETECTION_ENGINE_ALERT_ASSIGNEES_URL, {
    method: 'POST',
    version: '2023-10-31',
    body: JSON.stringify({
      assignees,
      ids
    }),
    signal
  });
};
exports.setAlertAssignees = setAlertAssignees;