"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentTypeForAgentIdField = void 0;
var _constants = require("../../../../../common/endpoint/service/response_actions/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Checks the provided `agentIdEcsField` path provided to see if it is being used by one
 * of the agent types that supports response actions and returns that agent type.
 * Defaults to `endpoint` if no match is found
 * @param agentIdEcsField
 */
const getAgentTypeForAgentIdField = agentIdEcsField => {
  for (const [fieldAgentType, fieldValues] of Object.entries(_constants.RESPONSE_ACTIONS_ALERT_AGENT_ID_FIELDS)) {
    if (fieldValues.includes(agentIdEcsField)) {
      return fieldAgentType;
    }
  }
  return 'endpoint';
};
exports.getAgentTypeForAgentIdField = getAgentTypeForAgentIdField;