"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlAuditIcon = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/ml_audit_icon/ml_audit_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var MessageLevels = /*#__PURE__*/function (MessageLevels) {
  MessageLevels["info"] = "info";
  MessageLevels["warning"] = "warning";
  MessageLevels["error"] = "error";
  return MessageLevels;
}(MessageLevels || {});
const MlAuditIconComponent = ({
  message
}) => {
  if (!message) {
    return null;
  }
  let color = 'primary';
  let icon = 'warning';
  if (message.level === MessageLevels.info) {
    icon = 'info';
  } else if (message.level === MessageLevels.warning) {
    color = 'warning';
  } else if (message.level === MessageLevels.error) {
    color = 'danger';
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: message.text,
    type: icon,
    color: color,
    iconProps: {
      'data-test-subj': 'mlJobAuditIcon'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  });
};
const MlAuditIcon = exports.MlAuditIcon = /*#__PURE__*/(0, _react.memo)(MlAuditIconComponent);