"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformRuleInterval = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformRuleInterval = interval => {
  const unitsSet = new Set(['s', 'm', 'h', 'd']);
  const match = interval === null || interval === void 0 ? void 0 : interval.match(/^(\d+)([a-zA-Z]+)$/);
  if (!match || !unitsSet.has(match[2])) {
    return undefined;
  }
  return [parseInt(match[1], 10), match[2]];
};
exports.transformRuleInterval = transformRuleInterval;