"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRevertPrebuiltRuleMutation = exports.REVERT_PREBUILT_RULE_KEY = void 0;
var _reactQuery = require("@kbn/react-query");
var _urls = require("../../../../../../common/api/detection_engine/prebuilt_rules/urls");
var _api = require("../../api");
var _use_fetch_coverage_overview_query = require("../use_fetch_coverage_overview_query");
var _use_fetch_rule_management_filters_query = require("../use_fetch_rule_management_filters_query");
var _use_find_rules_query = require("../use_find_rules_query");
var _use_fetch_prebuilt_rules_status_query = require("./use_fetch_prebuilt_rules_status_query");
var _use_fetch_prebuilt_rules_upgrade_review_query = require("./use_fetch_prebuilt_rules_upgrade_review_query");
var _retry_on_rate_limited_error = require("./retry_on_rate_limited_error");
var _capped_exponential_backoff = require("./capped_exponential_backoff");
var _use_fetch_prebuilt_rule_base_version_query = require("./use_fetch_prebuilt_rule_base_version_query");
var _use_fetch_rule_by_id_query = require("../use_fetch_rule_by_id_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REVERT_PREBUILT_RULE_KEY = exports.REVERT_PREBUILT_RULE_KEY = ['POST', _urls.REVERT_PREBUILT_RULES_URL];
const useRevertPrebuiltRuleMutation = options => {
  const invalidateFindRulesQuery = (0, _use_find_rules_query.useInvalidateFindRulesQuery)();
  const invalidatePrePackagedRulesStatus = (0, _use_fetch_prebuilt_rules_status_query.useInvalidateFetchPrebuiltRulesStatusQuery)();
  const invalidateFetchRuleManagementFilters = (0, _use_fetch_rule_management_filters_query.useInvalidateFetchRuleManagementFiltersQuery)();
  const invalidateFetchPrebuiltRulesUpgradeReview = (0, _use_fetch_prebuilt_rules_upgrade_review_query.useInvalidateFetchPrebuiltRulesUpgradeReviewQuery)();
  const invalidateRuleStatus = (0, _use_fetch_prebuilt_rules_status_query.useInvalidateFetchPrebuiltRulesStatusQuery)();
  const invalidateFetchCoverageOverviewQuery = (0, _use_fetch_coverage_overview_query.useInvalidateFetchCoverageOverviewQuery)();
  const invalidateFetchPrebuiltRuleBaseVerison = (0, _use_fetch_prebuilt_rule_base_version_query.useInvalidateFetchPrebuiltRuleBaseVersionQuery)();
  const invalidateFetchRuleByIdQuery = (0, _use_fetch_rule_by_id_query.useInvalidateFetchRuleByIdQuery)();
  return (0, _reactQuery.useMutation)(args => {
    return (0, _api.revertPrebuiltRule)(args);
  }, {
    ...options,
    mutationKey: REVERT_PREBUILT_RULE_KEY,
    onSettled: (...args) => {
      invalidatePrePackagedRulesStatus();
      invalidateFindRulesQuery();
      invalidateFetchRuleManagementFilters();
      invalidateFetchPrebuiltRulesUpgradeReview();
      invalidateRuleStatus();
      invalidateFetchCoverageOverviewQuery();
      invalidateFetchRuleByIdQuery();
      invalidateFetchPrebuiltRuleBaseVerison();
      if (options !== null && options !== void 0 && options.onSettled) {
        options.onSettled(...args);
      }
    },
    retry: _retry_on_rate_limited_error.retryOnRateLimitedError,
    retryDelay: _capped_exponential_backoff.cappedExponentialBackoff
  });
};
exports.useRevertPrebuiltRuleMutation = useRevertPrebuiltRuleMutation;