"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InlineKqlQueryReadOnly = InlineKqlQueryReadOnly;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _rule_definition_section = require("../../../../rule_definition_section");
var ruleDetailsI18n = _interopRequireWildcard(require("../../../../translations"));
var descriptionStepI18n = _interopRequireWildcard(require("../../../../../../../rule_creation_ui/components/description_step/translations"));
var _helpers = require("../../../../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_readonly/fields/kql_query/inline_kql_query.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultI18nLabels = {
  query: descriptionStepI18n.QUERY_LABEL,
  language: ruleDetailsI18n.QUERY_LANGUAGE_LABEL,
  filters: descriptionStepI18n.FILTERS_LABEL
};
function InlineKqlQueryReadOnly({
  kqlQuery,
  dataSource,
  i18nLabels = defaultI18nLabels
}) {
  const listItems = [{
    title: i18nLabels.query,
    description: /*#__PURE__*/_react.default.createElement(_rule_definition_section.Query, {
      query: kqlQuery.query,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 20
      }
    })
  }, {
    title: i18nLabels.language,
    description: (0, _helpers.getQueryLanguageLabel)(kqlQuery.language)
  }];
  if ((0, _helpers.isFilters)(kqlQuery.filters) && kqlQuery.filters.length > 0) {
    const dataSourceProps = (0, _helpers.getDataSourceProps)(dataSource);
    listItems.push({
      title: i18nLabels.filters,
      description: /*#__PURE__*/_react.default.createElement(_rule_definition_section.Filters, (0, _extends2.default)({
        filters: kqlQuery.filters
      }, dataSourceProps, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 20
        }
      }))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: listItems,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 10
    }
  });
}