"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrebuiltRulesCustomizationStatus = void 0;
var _use_prebuilt_rule_customization_upselling_message = require("./use_prebuilt_rule_customization_upselling_message");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Custom hook to determine prebuilt rules customization status.
 *
 * This hook checks if the feature flag for prebuilt rules customization is
 * enabled and returns the reason why it's disabled if it's the case.
 */
const usePrebuiltRulesCustomizationStatus = () => {
  // Upselling message is returned when the license level is insufficient,
  // otherwise it's undefined
  const upsellingMessage = (0, _use_prebuilt_rule_customization_upselling_message.usePrebuiltRuleCustomizationUpsellingMessage)('prebuilt_rule_customization');
  return {
    isRulesCustomizationEnabled: !upsellingMessage
  };
};
exports.usePrebuiltRulesCustomizationStatus = usePrebuiltRulesCustomizationStatus;