"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBadgeText = exports.getBadgeIcon = void 0;
var _rule_monitoring = require("../../../../../../../common/api/detection_engine/rule_monitoring");
var _utility_types = require("../../../../../../../common/utility_types");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBadgeIcon = type => {
  switch (type) {
    case _rule_monitoring.RuleExecutionEventTypeEnum.message:
      return 'console';
    case _rule_monitoring.RuleExecutionEventTypeEnum['status-change']:
      return 'dot';
    case _rule_monitoring.RuleExecutionEventTypeEnum['execution-metrics']:
      return 'gear';
    default:
      return (0, _utility_types.assertUnreachable)(type, 'Unknown rule execution event type');
  }
};
exports.getBadgeIcon = getBadgeIcon;
const getBadgeText = type => {
  switch (type) {
    case _rule_monitoring.RuleExecutionEventTypeEnum.message:
      return i18n.TYPE_MESSAGE;
    case _rule_monitoring.RuleExecutionEventTypeEnum['status-change']:
      return i18n.TYPE_STATUS_CHANGE;
    case _rule_monitoring.RuleExecutionEventTypeEnum['execution-metrics']:
      return i18n.TYPE_EXECUTION_METRICS;
    default:
      return (0, _utility_types.assertUnreachable)(type, 'Unknown rule execution event type');
  }
};
exports.getBadgeText = getBadgeText;