"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedUserMonitoringFilePickerStep = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _formatted_bytes = require("../../../../../../common/components/formatted_bytes");
var _constants = require("../../../../../../../common/constants");
var _constants2 = require("../constants");
var _use_privileged_monitoring_health = require("../../../../../hooks/use_privileged_monitoring_health");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring_onboarding/components/file_uploader/components/file_picker_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const privilegedUserMonitoringCSVSample = ['superadmin', 'admin01,Domain Admin', 'sec_ops', 'jdoe,IT Support'];
const PrivilegedUserMonitoringFilePickerStep = exports.PrivilegedUserMonitoringFilePickerStep = /*#__PURE__*/_react.default.memo(({
  onFileChange,
  errorMessage,
  isLoading
}) => {
  var _userStats$maxAllowed;
  const formatBytes = (0, _formatted_bytes.useFormatBytes)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    userStats
  } = (0, _use_privileged_monitoring_health.useUserLimitStatus)();
  const maxUsersAllowed = (_userStats$maxAllowed = userStats === null || userStats === void 0 ? void 0 : userStats.maxAllowed) !== null && _userStats$maxAllowed !== void 0 ? _userStats$maxAllowed : 10000; // fallback to default config value

  const listStyle = (0, _css.css)`
      list-style-type: disc;
      margin-bottom: ${euiTheme.size.l};
      margin-left: ${euiTheme.size.l};
      line-height: ${(0, _eui.useEuiFontSize)('s').lineHeight};
    `;
  const sampleCSVContent = privilegedUserMonitoringCSVSample.join('\n');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    paddingSize: "l",
    grow: false,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Supported file formats and size",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.filePicker.csvFileFormatRequirements",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    className: listStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "File formats: {formats}",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.filePicker.acceptedFileFormats",
    values: {
      formats: _constants2.SUPPORTED_FILE_EXTENSIONS.join(', ')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Maximum file size: {maxFileSize}",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.filePicker.uploadFileSizeLimit",
    values: {
      maxFileSize: formatBytes(_constants.CRITICALITY_CSV_MAX_SIZE_BYTES)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Maximum number of privileged users: {maxUsers}",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.filePicker.maxUsersLimit",
    values: {
      maxUsers: maxUsersAllowed
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "File structure",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.filePicker.CSVStructureTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    className: listStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{field}: privileged user\u2019s name",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.filePicker.userNameDescription",
    values: {
      field: /*#__PURE__*/_react.default.createElement("code", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 26
        }
      }, 'user.name')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{field} (optional): user role, group, team, or similar",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.filePicker.userLabelDescription",
    values: {
      field: /*#__PURE__*/_react.default.createElement("code", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 26
        }
      }, 'user.label')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Example",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.filePicker.exampleTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "csv",
    css: (0, _css.css)`
              background-color: ${euiTheme.colors.emptyShade};
            `,
    paddingSize: "s",
    lineNumbers: true,
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, sampleCSVContent)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    "data-test-subj": "privileged-user-monitoring-file-picker",
    accept: _constants2.SUPPORTED_FILE_TYPES.join(','),
    fullWidth: true,
    onChange: onFileChange,
    isInvalid: !!errorMessage,
    isLoading: isLoading,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.filePicker.AriaLabel', {
      defaultMessage: 'Privileged user monitoring file picker'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }), errorMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }, errorMessage));
});
PrivilegedUserMonitoringFilePickerStep.displayName = 'PrivilegedUserMonitoringFilePickerStep';