"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNIT = exports.SOURCE_IPS = exports.SOURCE_COUNTRIES = exports.ROWS_5 = exports.ROWS_10 = exports.FLOWS = exports.DESTINATION_IPS = exports.DESTINATION_COUNTRIES = exports.COUNTRY = exports.BYTES_OUT = exports.BYTES_IN = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.networkTopCountriesTable.heading.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {Country} other {Countries}}`
});
exports.UNIT = UNIT;
const COUNTRY = exports.COUNTRY = _i18n.i18n.translate('xpack.securitySolution.networkTopCountriesTable.column.countryTitle', {
  defaultMessage: 'Country'
});
const BYTES_IN = exports.BYTES_IN = _i18n.i18n.translate('xpack.securitySolution.networkTopCountriesTable.column.bytesInTitle', {
  defaultMessage: 'Bytes in'
});
const BYTES_OUT = exports.BYTES_OUT = _i18n.i18n.translate('xpack.securitySolution.networkTopCountriesTable.column.bytesOutTitle', {
  defaultMessage: 'Bytes out'
});
const FLOWS = exports.FLOWS = _i18n.i18n.translate('xpack.securitySolution.networkTopCountriesTable.column.flows', {
  defaultMessage: 'Flows'
});
const DESTINATION_COUNTRIES = exports.DESTINATION_COUNTRIES = _i18n.i18n.translate('xpack.securitySolution.networkTopCountriesTable.heading.destinationCountries', {
  defaultMessage: 'Destination countries'
});
const SOURCE_COUNTRIES = exports.SOURCE_COUNTRIES = _i18n.i18n.translate('xpack.securitySolution.networkTopCountriesTable.heading.sourceCountries', {
  defaultMessage: 'Source countries'
});
const DESTINATION_IPS = exports.DESTINATION_IPS = _i18n.i18n.translate('xpack.securitySolution.networkTopCountriesTable.column.destinationIps', {
  defaultMessage: 'Destination IPs'
});
const SOURCE_IPS = exports.SOURCE_IPS = _i18n.i18n.translate('xpack.securitySolution.networkTopCountriesTable.column.sourceIps', {
  defaultMessage: 'Source IPs'
});
const ROWS_5 = exports.ROWS_5 = _i18n.i18n.translate('xpack.securitySolution.networkTopCountriesTable.rows', {
  values: {
    numRows: 5
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
const ROWS_10 = exports.ROWS_10 = _i18n.i18n.translate('xpack.securitySolution.networkTopCountriesTable.rows', {
  values: {
    numRows: 10
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});