"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNetworkDetails = exports.ID = void 0;
var _react = require("react");
var _helpers = require("../../../../common/containers/helpers");
var _search_strategy = require("../../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_search_strategy = require("../../../../common/containers/use_search_strategy");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = exports.ID = 'networkDetailsQuery';
const useNetworkDetails = ({
  filterQuery,
  id = ID,
  indexNames,
  ip,
  skip
}) => {
  const {
    loading,
    result: response,
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _search_strategy.NetworkQueries.details,
    initialResult: {
      networkDetails: {}
    },
    errorMessage: i18n.ERROR_NETWORK_DETAILS,
    abort: skip
  });
  const networkDetailsResponse = (0, _react.useMemo)(() => ({
    networkDetails: response.networkDetails,
    id,
    inspect,
    isInspected: false,
    refetch
  }), [id, inspect, refetch, response.networkDetails]);
  const networkDetailsRequest = (0, _react.useMemo)(() => ({
    defaultIndex: indexNames,
    factoryQueryType: _search_strategy.NetworkQueries.details,
    filterQuery: (0, _helpers.createFilter)(filterQuery),
    ip
  }), [filterQuery, indexNames, ip]);
  (0, _react.useEffect)(() => {
    if (!skip && networkDetailsRequest) {
      search(networkDetailsRequest);
    }
  }, [networkDetailsRequest, search, skip]);
  return [loading, networkDetailsResponse];
};
exports.useNetworkDetails = useNetworkDetails;