"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.navTabsNetwork = void 0;
var _fp = require("lodash/fp");
var i18n = _interopRequireWildcard(require("../translations"));
var _types = require("./types");
var _constants = require("../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTabsOnNetworkUrl = tabName => `${_constants.NETWORK_PATH}/${tabName}`;
const navTabsNetwork = hasMlUserPermissions => {
  const networkNavTabs = {
    [_types.NetworkRouteType.events]: {
      id: _types.NetworkRouteType.events,
      name: i18n.NAVIGATION_EVENTS_TITLE,
      href: getTabsOnNetworkUrl(_types.NetworkRouteType.events),
      disabled: false
    },
    [_types.NetworkRouteType.flows]: {
      id: _types.NetworkRouteType.flows,
      name: i18n.NAVIGATION_FLOWS_TITLE,
      href: getTabsOnNetworkUrl(_types.NetworkRouteType.flows),
      disabled: false
    },
    [_types.NetworkRouteType.dns]: {
      id: _types.NetworkRouteType.dns,
      name: i18n.NAVIGATION_DNS_TITLE,
      href: getTabsOnNetworkUrl(_types.NetworkRouteType.dns),
      disabled: false
    },
    [_types.NetworkRouteType.http]: {
      id: _types.NetworkRouteType.http,
      name: i18n.NAVIGATION_HTTP_TITLE,
      href: getTabsOnNetworkUrl(_types.NetworkRouteType.http),
      disabled: false
    },
    [_types.NetworkRouteType.tls]: {
      id: _types.NetworkRouteType.tls,
      name: i18n.NAVIGATION_TLS_TITLE,
      href: getTabsOnNetworkUrl(_types.NetworkRouteType.tls),
      disabled: false
    },
    [_types.NetworkRouteType.anomalies]: {
      id: _types.NetworkRouteType.anomalies,
      name: i18n.NAVIGATION_ANOMALIES_TITLE,
      href: getTabsOnNetworkUrl(_types.NetworkRouteType.anomalies),
      disabled: false
    }
  };
  return hasMlUserPermissions ? networkNavTabs : (0, _fp.omit)([_types.NetworkRouteType.anomalies], networkNavTabs);
};
exports.navTabsNetwork = navTabsNetwork;