"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ERROR_FETCHING_DNS_DATA = exports.DOMAINS_COUNT_BY = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ERROR_FETCHING_DNS_DATA = exports.ERROR_FETCHING_DNS_DATA = _i18n.i18n.translate('xpack.securitySolution.hosts.navigation.dns.histogram.errorFetchingDnsData', {
  defaultMessage: 'Failed to query DNS data'
});
const DOMAINS_COUNT_BY = groupByField => _i18n.i18n.translate('xpack.securitySolution.network.dns.stackByUniqueSubdomain', {
  values: {
    groupByField
  },
  defaultMessage: 'Top domains by {groupByField}'
});
exports.DOMAINS_COUNT_BY = DOMAINS_COUNT_BY;