"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDocumentDetails = void 0;
var _react = require("react");
var _use_get_fields_data = require("../../document_details/shared/hooks/use_get_fields_data");
var _details = require("../../../timelines/containers/details");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to retrieve event details for EASE alert details flyout context
 */
const useDocumentDetails = ({
  dataView,
  documentId
}) => {
  const indexName = (0, _react.useMemo)(() => dataView ? dataView.getIndexPattern() : '', [dataView]);
  const runtimeMappings = dataView === null || dataView === void 0 ? void 0 : dataView.getRuntimeMappings();
  const [loading, dataFormattedForFieldBrowser, searchHit, dataAsNestedObject] = (0, _details.useTimelineEventsDetails)({
    indexName,
    eventId: documentId || '',
    runtimeMappings,
    skip: !documentId || !dataView
  });
  const {
    getFieldsData
  } = (0, _use_get_fields_data.useGetFieldsData)({
    fieldsData: searchHit === null || searchHit === void 0 ? void 0 : searchHit.fields
  });
  return {
    dataAsNestedObject,
    dataFormattedForFieldBrowser,
    getFieldsData,
    loading
  };
};
exports.useDocumentDetails = useDocumentDetails;