"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventCategoryDescription = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _context = require("../../shared/context");
var _event_utils = require("../utils/event_utils");
var _utils = require("../../shared/utils");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/event_category_description.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Displays the category description of an event document.
 */
const EventCategoryDescription = () => {
  const {
    getFieldsData
  } = (0, _context.useDocumentDetailsContext)();
  const eventCategories = (0, _react.useMemo)(() => (0, _utils.getFieldArray)(getFieldsData('event.category')), [getFieldsData]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, eventCategories.map(category => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `${_test_ids.EVENT_CATEGORY_DESCRIPTION_TEST_ID}-${category}`,
    key: `event-category-${category}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 13
    }
  }, (0, _lodash.startCase)(category))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 11
    }
  }, (0, _event_utils.getEcsAllowedValueDescription)('event.category', category)))));
};
exports.EventCategoryDescription = EventCategoryDescription;
EventCategoryDescription.displayName = 'EventCategoryDescription';