"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _left = require("../../left");
var _test_ids = require("./test_ids");
var _use_navigate_to_left_panel = require("../../shared/hooks/use_navigate_to_left_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/response_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Response button that opens Response section in the left panel
 */
const ResponseButton = () => {
  const {
    navigateToLeftPanel: goToResponseTab
  } = (0, _use_navigate_to_left_panel.useNavigateToLeftPanel)({
    tab: _left.LeftPanelResponseTab
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: goToResponseTab,
    iconType: "documentation",
    "data-test-subj": _test_ids.RESPONSE_BUTTON_TEST_ID,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.response.responseButtonLabel",
    defaultMessage: "Response",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 9
    }
  })));
};
exports.ResponseButton = ResponseButton;
ResponseButton.displayName = 'ResponseButton';