"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAccordionState = exports.toggleReducer = void 0;
var _react = require("react");
var _kibana = require("../../../../common/lib/kibana");
var _local_storage = require("../../shared/constants/local_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOSED = 'closed';
const OPEN = 'open';
/**
 * Reducer for toggling between expanded and collapsed states.
 * Every time the user takes an action, we store the new state in local storage. This allows to preserve the state when opening new flyouts or when refreshing the page.
 * The object stored is a map of section names to expanded boolean values.
 */
const toggleReducer = (state, action) => {
  const {
    storage,
    title
  } = action;
  if (storage && title) {
    const localStorage = storage.get(_local_storage.FLYOUT_STORAGE_KEYS.OVERVIEW_TAB_EXPANDED_SECTIONS);
    storage.set(_local_storage.FLYOUT_STORAGE_KEYS.OVERVIEW_TAB_EXPANDED_SECTIONS, {
      ...localStorage,
      [title]: state !== OPEN
    });
  }
  return state === CLOSED ? OPEN : CLOSED;
};
exports.toggleReducer = toggleReducer;
/**
 * Hook to control the state of the EuiAccordion. It will store the state in local storage if the localStorageKey is provided.
 * @param expandedInitially - is accordion expanded on first render
 */
const useAccordionState = expandedInitially => {
  const {
    storage
  } = (0, _kibana.useKibana)().services;
  const initialState = expandedInitially ? OPEN : CLOSED;
  const [state, toggleState] = (0, _react.useReducer)(toggleReducer, initialState);
  const renderContent = state === OPEN;
  const toggle = title => {
    toggleState({
      storage,
      title
    });
  };
  return {
    renderContent,
    state,
    toggle
  };
};
exports.useAccordionState = useAccordionState;