"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowRelatedAlertsByAncestry = void 0;
var _investigate_in_resolver = require("../../../../detections/components/alerts_table/timeline_actions/investigate_in_resolver");
var _use_license = require("../../../../common/hooks/use_license");
var _field_names = require("../constants/field_names");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns true if the user has at least platinum privilege, and if the document has ancestry data
 */
const useShowRelatedAlertsByAncestry = ({
  getFieldsData,
  dataAsNestedObject,
  eventId,
  isRulePreview
}) => {
  var _getField;
  const hasProcessEntityInfo = (0, _investigate_in_resolver.useIsInvestigateInResolverActionEnabled)(dataAsNestedObject);
  const ancestorId = (_getField = (0, _utils.getField)(getFieldsData(_field_names.ANCESTOR_ID))) !== null && _getField !== void 0 ? _getField : '';
  const documentId = isRulePreview ? ancestorId : eventId;
  const hasAtLeastPlatinum = (0, _use_license.useLicense)().isPlatinumPlus();
  const show = hasProcessEntityInfo && hasAtLeastPlatinum;
  return {
    show,
    documentId
  };
};
exports.useShowRelatedAlertsByAncestry = useShowRelatedAlertsByAncestry;