"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useManagedUserItems = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _store = require("../../../../explore/users/store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useManagedUserItems = (tableType, managedUserDetails) => {
  const tableData = (0, _reactRedux.useSelector)(state => _store.usersSelectors.selectUserAssetTableById(state, tableType));
  return (0, _react.useMemo)(() => tableData.fields.map(fieldName => ({
    value: managedUserDetails[fieldName],
    field: fieldName
  })), [managedUserDetails, tableData.fields]);
};
exports.useManagedUserItems = useManagedUserItems;