"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SHOW_COMMENTS_LABEL = exports.POLICY_EFFECT_SCOPE_TITLE = exports.POLICY_EFFECT_SCOPE = exports.OS_WINDOWS = exports.OS_MAC = exports.OS_LINUX = exports.MANAGEMENT_OF_SHARED_PER_POLICY_ARTIFACT_NOT_ALLOWED_MESSAGE = exports.LAST_UPDATED_BY = exports.LAST_UPDATED = exports.HIDE_COMMENTS_LABEL = exports.GLOBAL_EFFECT_SCOPE = exports.EXPAND_ACTION = exports.DESCRIPTION_LABEL = exports.CREATED_BY = exports.CREATED = exports.CONDITION_OS = exports.CONDITION_OPERATOR_TYPE_WILDCARD_MATCHES = exports.CONDITION_OPERATOR_TYPE_NOT_MATCH_ANY = exports.CONDITION_OPERATOR_TYPE_NOT_MATCH = exports.CONDITION_OPERATOR_TYPE_NESTED = exports.CONDITION_OPERATOR_TYPE_MATCH_ANY = exports.CONDITION_OPERATOR_TYPE_MATCH = exports.CONDITION_OPERATOR_TYPE_LIST = exports.CONDITION_OPERATOR_TYPE_EXISTS = exports.CONDITION_OPERATOR_TYPE_DOES_NOT_MATCH = exports.CONDITION_AND = exports.COLLAPSE_ACTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LAST_UPDATED = exports.LAST_UPDATED = _i18n.i18n.translate('xpack.securitySolution.artifactCard.lastUpdated', {
  defaultMessage: 'Last updated'
});
const CREATED = exports.CREATED = _i18n.i18n.translate('xpack.securitySolution.artifactCard.created', {
  defaultMessage: 'Created'
});
const LAST_UPDATED_BY = exports.LAST_UPDATED_BY = _i18n.i18n.translate('xpack.securitySolution.artifactCard.lastUpdatedBy', {
  defaultMessage: 'Updated by'
});
const CREATED_BY = exports.CREATED_BY = _i18n.i18n.translate('xpack.securitySolution.artifactCard.createdBy', {
  defaultMessage: 'Created by'
});
const GLOBAL_EFFECT_SCOPE = exports.GLOBAL_EFFECT_SCOPE = _i18n.i18n.translate('xpack.securitySolution.artifactCard.globalEffectScope', {
  defaultMessage: 'Applied globally'
});
const POLICY_EFFECT_SCOPE = (policyCount = 0) => {
  return _i18n.i18n.translate('xpack.securitySolution.artifactCard.policyEffectScope', {
    defaultMessage: 'Applied to {count} {count, plural, one {policy} other {policies}}',
    values: {
      count: policyCount
    }
  });
};
exports.POLICY_EFFECT_SCOPE = POLICY_EFFECT_SCOPE;
const POLICY_EFFECT_SCOPE_TITLE = (policyCount = 0) => _i18n.i18n.translate('xpack.securitySolution.artifactCard.policyEffectScope.title', {
  defaultMessage: 'Applied to the following {count, plural, one {policy} other {policies}}',
  values: {
    count: policyCount
  }
});
exports.POLICY_EFFECT_SCOPE_TITLE = POLICY_EFFECT_SCOPE_TITLE;
const CONDITION_OPERATOR_TYPE_MATCH = exports.CONDITION_OPERATOR_TYPE_MATCH = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.matchOperator', {
  defaultMessage: 'IS'
});
const CONDITION_OPERATOR_TYPE_NOT_MATCH = exports.CONDITION_OPERATOR_TYPE_NOT_MATCH = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.matchOperator.not', {
  defaultMessage: 'IS NOT'
});
const CONDITION_OPERATOR_TYPE_WILDCARD_MATCHES = exports.CONDITION_OPERATOR_TYPE_WILDCARD_MATCHES = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.wildcardMatchesOperator', {
  defaultMessage: 'MATCHES'
});
const CONDITION_OPERATOR_TYPE_DOES_NOT_MATCH = exports.CONDITION_OPERATOR_TYPE_DOES_NOT_MATCH = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.wildcardDoesNotMatchOperator', {
  defaultMessage: 'DOES NOT MATCH'
});
const CONDITION_OPERATOR_TYPE_NESTED = exports.CONDITION_OPERATOR_TYPE_NESTED = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.nestedOperator', {
  defaultMessage: 'has'
});
const CONDITION_OPERATOR_TYPE_MATCH_ANY = exports.CONDITION_OPERATOR_TYPE_MATCH_ANY = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.matchAnyOperator', {
  defaultMessage: 'is one of'
});
const CONDITION_OPERATOR_TYPE_NOT_MATCH_ANY = exports.CONDITION_OPERATOR_TYPE_NOT_MATCH_ANY = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.matchAnyOperator.not', {
  defaultMessage: 'is not one of'
});
const CONDITION_OPERATOR_TYPE_EXISTS = exports.CONDITION_OPERATOR_TYPE_EXISTS = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.existsOperator', {
  defaultMessage: 'exists'
});
const CONDITION_OPERATOR_TYPE_LIST = exports.CONDITION_OPERATOR_TYPE_LIST = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.listOperator', {
  defaultMessage: 'included in'
});
const CONDITION_OS = exports.CONDITION_OS = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.os', {
  defaultMessage: 'OS'
});
const CONDITION_AND = exports.CONDITION_AND = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.and', {
  defaultMessage: 'AND'
});
const OS_WINDOWS = exports.OS_WINDOWS = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.windows', {
  defaultMessage: 'Windows'
});
const OS_LINUX = exports.OS_LINUX = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.linux', {
  defaultMessage: 'Linux'
});
const OS_MAC = exports.OS_MAC = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.macos', {
  defaultMessage: 'Mac'
});
const EXPAND_ACTION = exports.EXPAND_ACTION = _i18n.i18n.translate('xpack.securitySolution.artifactExpandableCard.expand', {
  defaultMessage: 'Expand'
});
const COLLAPSE_ACTION = exports.COLLAPSE_ACTION = _i18n.i18n.translate('xpack.securitySolution.artifactExpandableCard.collpase', {
  defaultMessage: 'Collapse'
});
const SHOW_COMMENTS_LABEL = (count = 0) => _i18n.i18n.translate('xpack.securitySolution.artifactCard.comments.label.show', {
  defaultMessage: 'Show comments ({count})',
  values: {
    count
  }
});
exports.SHOW_COMMENTS_LABEL = SHOW_COMMENTS_LABEL;
const HIDE_COMMENTS_LABEL = (count = 0) => _i18n.i18n.translate('xpack.securitySolution.artifactCard.comments.label.hide', {
  defaultMessage: 'Hide comments ({count})',
  values: {
    count
  }
});
exports.HIDE_COMMENTS_LABEL = HIDE_COMMENTS_LABEL;
const DESCRIPTION_LABEL = exports.DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.securitySolution.artifactMinifiedCard.descriptionLabel', {
  defaultMessage: 'Description'
});
const MANAGEMENT_OF_SHARED_PER_POLICY_ARTIFACT_NOT_ALLOWED_MESSAGE = exports.MANAGEMENT_OF_SHARED_PER_POLICY_ARTIFACT_NOT_ALLOWED_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.translations.sharedPerPolicyArtifactNotAllowed', {
  defaultMessage: 'Management of artifacts shared across multiple spaces is only allowed from the space where it was created from'
});