"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommandInput = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _classnames = _interopRequireDefault(require("classnames"));
var _input_display = require("./components/input_display");
var _use_with_input_show_popover = require("../../hooks/state_selectors/use_with_input_show_popover");
var _entered_input = require("./lib/entered_input");
var _input_capture = require("./components/input_capture");
var _use_with_input_visible_state = require("../../hooks/state_selectors/use_with_input_visible_state");
var _use_input_hints = require("./hooks/use_input_hints");
var _input_placeholder = require("./components/input_placeholder");
var _use_with_input_text_entered = require("../../hooks/state_selectors/use_with_input_text_entered");
var _input_area_popover = require("./components/input_area_popover");
var _use_console_state_dispatch = require("../../hooks/state_selectors/use_console_state_dispatch");
var _use_test_id_generator = require("../../../../hooks/use_test_id_generator");
var _use_data_test_subj = require("../../hooks/state_selectors/use_data_test_subj");
var _use_with_command_list = require("../../hooks/state_selectors/use_with_command_list");
var _utils = require("./lib/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/command_input/command_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CommandInputContainer = _styledComponents.default.div`
  background-color: ${({
  theme: {
    eui
  }
}) => eui.euiFormBackgroundColor};
  border-radius: ${({
  theme: {
    eui
  }
}) => eui.euiBorderRadius};
  padding: ${({
  theme: {
    eui
  }
}) => eui.euiSizeS};
  outline: ${({
  theme: {
    eui
  }
}) => eui.euiBorderThin};

  &:focus-within {
    border-bottom: ${({
  theme: {
    eui
  }
}) => eui.euiBorderThick};
    border-bottom-color: ${({
  theme: {
    eui
  }
}) => eui.euiColorPrimary};
  }

  &.error {
    border-bottom-color: ${({
  theme: {
    eui
  }
}) => eui.euiColorDanger};
  }

  .textEntered {
    white-space: break-spaces;
  }

  .prompt {
    padding-right: 1ch;
  }

  &.withPopover {
    border-top-left-radius: 0;
    border-top-right-radius: 0;
  }

  &.hasFocus {
    // Cursor is defined in '<InputDisplay>' component
    .cursor {
      background-color: ${({
  theme: {
    eui
  }
}) => eui.euiTextColor};
      animation: cursor-blink-animation 1s steps(5, start) infinite;
      -webkit-animation: cursor-blink-animation 1s steps(5, start) infinite;

      @keyframes cursor-blink-animation {
        to {
          visibility: hidden;
        }
      }
      @-webkit-keyframes cursor-blink-animation {
        to {
          visibility: hidden;
        }
      }
    }
  }
`;
const CommandInput = exports.CommandInput = /*#__PURE__*/(0, _react.memo)(({
  prompt = '',
  focusRef,
  ...commonProps
}) => {
  (0, _use_input_hints.useInputHints)();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const commands = (0, _use_with_command_list.useWithCommandList)();
  const {
    rightOfCursorText,
    leftOfCursorText,
    fullTextEntered,
    enteredCommand,
    parsedInput
  } = (0, _use_with_input_text_entered.useWithInputTextEntered)();
  const visibleState = (0, _use_with_input_visible_state.useWithInputVisibleState)();
  const isPopoverOpen = !!(0, _use_with_input_show_popover.useWithInputShowPopover)();
  const [isKeyInputBeingCaptured, setIsKeyInputBeingCaptured] = (0, _react.useState)(false);
  const [commandToExecute, setCommandToExecute] = (0, _react.useState)(undefined);
  const [popoverWidth, setPopoverWidth] = (0, _react.useState)('94vw');
  const _focusRef = (0, _react.useRef)(null);
  const keyCaptureFocusRef = focusRef || _focusRef;
  const inputContainerClassname = (0, _react.useMemo)(() => {
    return (0, _classnames.default)({
      cmdInput: true,
      hasFocus: isKeyInputBeingCaptured,
      error: visibleState === 'error',
      withPopover: isPopoverOpen
    });
  }, [isKeyInputBeingCaptured, isPopoverOpen, visibleState]);
  const disableArrowButton = (0, _react.useMemo)(() => fullTextEntered.trim().length === 0, [fullTextEntered]);
  const userInput = (0, _react.useMemo)(() => {
    return new _entered_input.EnteredInput(leftOfCursorText, rightOfCursorText, parsedInput, enteredCommand);
  }, [enteredCommand, leftOfCursorText, parsedInput, rightOfCursorText]);
  const handleOnResize = (0, _react.useCallback)(({
    width
  }) => {
    if (width > 0) {
      setPopoverWidth(`${width}px`);
    }
  }, []);
  const handleSubmitButton = (0, _react.useCallback)(() => {
    setCommandToExecute({
      input: userInput.getFullText(true),
      enteredCommand,
      parsedInput
    });
  }, [enteredCommand, parsedInput, userInput]);
  const handleOnChangeFocus = (0, _react.useCallback)(hasFocus => {
    setIsKeyInputBeingCaptured(hasFocus);
  }, []);
  const handleTypingAreaClick = (0, _react.useCallback)(ev => {
    if (keyCaptureFocusRef.current) {
      keyCaptureFocusRef.current.focus();
    }
    if (isPopoverOpen) {
      dispatch({
        type: 'updateInputPopoverState',
        payload: {
          show: undefined
        }
      });
    }
  }, [dispatch, isPopoverOpen, keyCaptureFocusRef]);
  const handleInputCapture = (0, _react.useCallback)(({
    value,
    selection,
    eventDetails
  }) => {
    const key = eventDetails.code;

    // UP arrow key
    if (key === 'ArrowUp') {
      dispatch({
        type: 'removeFocusFromKeyCapture'
      });
      dispatch({
        type: 'updateInputPopoverState',
        payload: {
          show: 'input-history'
        }
      });
      return;
    }

    // Handle any input value by pre-processing selector arguments (paste, history, etc.)
    let processedValue = value;
    let extractedArgState = {};
    if (value) {
      const preProcessResult = (0, _utils.detectAndPreProcessPastedCommand)(value, commands);
      if (preProcessResult.hasSelectorArguments) {
        processedValue = preProcessResult.cleanedCommand;
        extractedArgState = preProcessResult.extractedArgState;
      }
    }

    // Update the store with the updated text that was entered
    dispatch({
      type: 'updateInputTextEnteredState',
      payload: ({
        leftOfCursorText: prevLeftOfCursor,
        rightOfCursorText: prevRightOfCursor,
        enteredCommand: prevEnteredCommand,
        parsedInput: prevParsedInput
      }) => {
        var _processedValue;
        const inputText = new _entered_input.EnteredInput(prevLeftOfCursor, prevRightOfCursor, prevParsedInput, prevEnteredCommand);
        inputText.addValue((_processedValue = processedValue) !== null && _processedValue !== void 0 ? _processedValue : '', selection);
        switch (key) {
          // BACKSPACE
          case 'Backspace':
            inputText.backspaceChar(selection);
            break;

          // DELETE
          case 'Delete':
            inputText.deleteChar(selection);
            break;

          // ENTER = Execute command and blank out the input area
          case 'Enter':
            setCommandToExecute({
              input: inputText.getFullText(true),
              enteredCommand: prevEnteredCommand,
              parsedInput: prevParsedInput
            });
            inputText.clear();
            break;

          // ARROW LEFT
          case 'ArrowLeft':
            inputText.moveCursorTo('left');
            break;

          // ARROW RIGHT
          case 'ArrowRight':
            inputText.moveCursorTo('right');
            break;

          // HOME
          case 'Home':
            inputText.moveCursorTo('home');
            break;

          // END
          case 'End':
            inputText.moveCursorTo('end');
            break;
        }
        return {
          leftOfCursorText: inputText.getLeftOfCursorText(),
          rightOfCursorText: inputText.getRightOfCursorText(),
          argState: {
            ...inputText.getArgState(),
            ...extractedArgState
          }
        };
      }
    });
  }, [commands, dispatch]);

  // Execute the command if one was ENTER'd.
  (0, _react.useEffect)(() => {
    if (commandToExecute) {
      dispatch({
        type: 'executeCommand',
        payload: commandToExecute
      });
      setCommandToExecute(undefined);

      // reset input
      dispatch({
        type: 'updateInputTextEnteredState',
        payload: {
          leftOfCursorText: '',
          rightOfCursorText: ''
        }
      });
    }
  }, [commandToExecute, dispatch]);
  return /*#__PURE__*/_react.default.createElement(_input_area_popover.InputAreaPopover, {
    width: popoverWidth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: handleOnResize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 7
    }
  }, resizeRef => {
    return /*#__PURE__*/_react.default.createElement(CommandInputContainer, (0, _extends2.default)({}, commonProps, {
      className: inputContainerClassname,
      onClick: handleTypingAreaClick,
      ref: resizeRef,
      "data-test-subj": getTestId('cmdInput-container'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 274,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      alignItems: "center",
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 15
      }
    }, prompt && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": getTestId('cmdInput-prompt'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 283,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-displayInlineBlock prompt",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 284,
        columnNumber: 21
      }
    }, prompt)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "textEntered",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_input_capture.InputCapture, {
      onCapture: handleInputCapture,
      onChangeFocus: handleOnChangeFocus,
      focusRef: focusRef,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 288,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_input_display.InputDisplay, {
      leftOfCursor: userInput.getLeftOfCursorRenderingContent(),
      rightOfCursor: userInput.getRightOfCursorRenderingContent(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_input_placeholder.InputPlaceholder, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 300,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": getTestId('inputTextSubmitButton'),
      "aria-label": "submit-command",
      iconType: "playFilled",
      color: "primary",
      isDisabled: disableArrowButton,
      onClick: handleSubmitButton,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 301,
        columnNumber: 19
      }
    }))));
  }));
});
CommandInput.displayName = 'CommandInput';