"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IsolateActionResult = void 0;
var _react = require("react");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_console_action_submitter = require("../hooks/use_console_action_submitter");
var _use_send_isolate_endpoint_request = require("../../../hooks/response_actions/use_send_isolate_endpoint_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IsolateActionResult = exports.IsolateActionResult = /*#__PURE__*/(0, _react.memo)(({
  command,
  setStore,
  store,
  status,
  setStatus,
  ResultComponent
}) => {
  var _command$args$args2, _command$commandDefin3;
  const isSentinelOneV1Enabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('responseActionsSentinelOneV1Enabled');
  const isolateHostApi = (0, _use_send_isolate_endpoint_request.useSendIsolateEndpointRequest)();
  const actionRequestBody = (0, _react.useMemo)(() => {
    var _command$commandDefin, _command$commandDefin2, _command$args$args, _command$args$args$co;
    const {
      agentType,
      endpointId
    } = (_command$commandDefin = (_command$commandDefin2 = command.commandDefinition) === null || _command$commandDefin2 === void 0 ? void 0 : _command$commandDefin2.meta) !== null && _command$commandDefin !== void 0 ? _command$commandDefin : {};
    const comment = (_command$args$args = command.args.args) === null || _command$args$args === void 0 ? void 0 : (_command$args$args$co = _command$args$args.comment) === null || _command$args$args$co === void 0 ? void 0 : _command$args$args$co[0];
    return endpointId ? {
      agent_type: isSentinelOneV1Enabled ? agentType : undefined,
      endpoint_ids: [endpointId],
      comment
    } : undefined;
  }, [(_command$args$args2 = command.args.args) === null || _command$args$args2 === void 0 ? void 0 : _command$args$args2.comment, (_command$commandDefin3 = command.commandDefinition) === null || _command$commandDefin3 === void 0 ? void 0 : _command$commandDefin3.meta, isSentinelOneV1Enabled]);
  return (0, _use_console_action_submitter.useConsoleActionSubmitter)({
    ResultComponent,
    setStore,
    store,
    status,
    setStatus,
    actionCreator: isolateHostApi,
    actionRequestBody,
    dataTestSubj: 'isolate'
  }).result;
});
IsolateActionResult.displayName = 'IsolateActionResult';